#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "person.h"

/*
 *
 * Uses person.c / person.h
 *
 */

int main() {
    person *p;
    int ret_code;

    p=NULL;

    printf(" main p: %p\n", (void*) p);
    printf(" main p: %p\n", (void*) &p);
    ret_code = add_one_person(&p, 1, "Henry", "Rollins");
    if (ret_code != 0 ) {
        fprintf(stderr, "Mem alloc failure: %d\n", ret_code);
        return 2; // indicate errror to user
    }
    printf(" main p: %p\n", (void*) p);
    printf("First name:   %s\n", p[0].first_name);
    printf("Family name:  %s\n", p[0].family_name);

    ret_code = add_one_person(&p, 2, "Henry", "Chinaski");
    if (ret_code != 0 ) {
        fprintf(stderr, "Mem alloc failure: %d\n", ret_code);
        return 2; // indicate errror to user
    }

    printf ("--------------\n");
    printf("First name:   %s\n", p[0].first_name);
    printf("Family name:  %s\n", p[0].family_name);
    printf("First name:   %s\n", p[1].first_name);
    printf("Family name:  %s\n", p[1].family_name);


    free_persons(p, 2);
    return 0;
}
